// src/quality/resolveScore10.ts
export type FilterDef = {
  key: string;
  label: string;
  weight: number;
  maxScore: number; // typically 10
  id: string;       // key in component_quality.json
  category: string; // key/path in bikes.json to read raw value
  explanation?: string;
};

export type ComponentQuality = Record<string, Record<string, number>>;

const pick = (obj: any, pathStr: string) =>
  (pathStr ?? '').split('.').reduce((o, k) => (o == null ? undefined : o[k]), obj);

const norm = (v: unknown) => String(v ?? '').trim().toLowerCase();

/** Generic lookup: (category -> rawValue) -> component_quality[id][rawValue] */
export function resolveScore10(
  filter: FilterDef,
  bike: any,
  qualityTables: ComponentQuality
): number {
  const rawPath = filter.category;
  const rawValue = norm(pick(bike, rawPath) ?? (bike && (bike as any)[rawPath]));
  const table = qualityTables?.[filter.id] ?? {};
  const val = Object.prototype.hasOwnProperty.call(table, rawValue) ? table[rawValue] : table['_default'];

  const clamped = typeof val === 'number' ? Math.max(0, Math.min(filter.maxScore ?? 10, val)) : 0;
  return clamped;
}

export function contributionPoints(filter: FilterDef, bike: any, quality: ComponentQuality) {
  const score10 = resolveScore10(filter, bike, quality);
  const points = (score10 / (filter.maxScore ?? 10)) * filter.weight;
  return { score10, points };
}
