# Comparateur VAE

Ce dépôt propose un prototype statique permettant de comparer des vélos à assistance électrique (VAE) selon un score de fiabilité calculé sur 12 sous-critères techniques. Une seconde métrique évalue l'autonomie (1–10) à partir d'un barème pondéré (capacité batterie, cellules, moteur, pneus, transmission...).

## Structure du projet

```
.
├── index.html          # Page principale
├── css/styles.css      # Feuille de style moderne (Inter, design responsive)
├── js/app.js           # Logique client : filtre, tri et visualisation des scores
├── scoring/            # Moteur de scoring Python (filtres pondérés)
├── tests/              # Tests unitaires Pytest pour le moteur
└── public/
    ├── bikes.json        # Dataset détaillé (scores + sous-critères)
    ├── bikes-compat.json # Dataset compatibilité (fiabilité stockée dans componentsScore)
    └── brand-info.json   # Métadonnées fabricants (site officiel, année de création)
```

## Fonctionnalités clés

- Recherche plein texte sur la marque ou le modèle
- Filtre par catégorie, seuil d'autonomie et option pour afficher uniquement les modèles notés
- Tri dynamique (marque, modèle, fiabilité, autonomie, performances route/hors-route, utilité & confort) avec inversion du sens
- Visualisation détaillée de chaque score (popover) avec la contribution des sous-critères
- Affiche pour chaque marque (si disponible) l'année de création et un lien vers le site officiel grâce à `brand-info.json`
- Mise en page responsive avec score visuel (barre colorée) et badges de catégories

## Utilisation

1. Ouvre `index.html` dans un navigateur moderne.

Le dataset `public/bikes.json` inclut les 12 sous-critères utilisés pour le calcul du score (marque moteur, type de suspension, certification UL, etc.) et une note sur 10 déjà calculée.


## Moteur de scoring Python

Le dossier `scoring/` expose trois fonctions qui implémentent les filtres
pondérés décrits sur ebikereviewcanada.com :

- `compute_road_performance_score` – performances sur route
- `compute_offroad_performance_score` – performances hors-route
- `compute_utility_comfort_score` – utilité & confort

Chaque fonction accepte un dictionnaire décrivant les spécifications d'un
vélo (valeurs numériques ou descripteurs textuels) et renvoie un
`FilterResult` contenant :

- `raw_score` : la somme pondérée brute,
- `normalized_score` : le score ramené sur une échelle 1–10,
- `max_raw_score` : le maximum atteignable selon les sous-critères
  disponibles,
- `breakdown` : les sous-critères évalués et leur note respective.

### Exécution des tests

```bash
python -m pytest
```

Les tests couvrent les principaux scénarios (valeurs numériques, libellés
textuels et données partielles).
